/*------------------------------------------
   PalmNotePadFILE.C -- PalmNotePadup Editor File Functions
  ------------------------------------------*/

#include <windows.h>
#include <windowsx.h>
#include <commdlg.h>
#include <stdlib.h>


static OPENFILENAME ofn ;

void PalmNotePadFileInitialize (HWND hwnd)
{
	static TCHAR szFilter[] = TEXT("Text Files (*.TXT)\0*.txt\0ASCII Files (*.ASC)\0*.asc\0All Files (*.*)\0*.*\0\0");

	ofn.lStructSize       = sizeof (OPENFILENAME) ;
	ofn.hwndOwner         = hwnd ;
	ofn.hInstance         = NULL ;
	ofn.lpstrFilter       = szFilter ;
	ofn.lpstrCustomFilter = NULL ;
	ofn.nMaxCustFilter    = 0 ;
	ofn.nFilterIndex      = 0 ;
	ofn.lpstrFile         = NULL ;          // Set in Open and Close functions
	ofn.nMaxFile          = _MAX_PATH ;
	ofn.lpstrFileTitle    = NULL ;          // Set in Open and Close functions
	ofn.nMaxFileTitle     = _MAX_FNAME + _MAX_EXT ;
	ofn.lpstrInitialDir   = NULL ;
	ofn.lpstrTitle        = NULL ;
	ofn.Flags             = 0 ;             // Set in Open and Close functions
	ofn.nFileOffset       = 0 ;
	ofn.nFileExtension    = 0 ;
	ofn.lpstrDefExt       = TEXT("txt") ;
	ofn.lCustData         = 0L ;
	ofn.lpfnHook          = NULL ;
	ofn.lpTemplateName    = NULL ;
}

BOOL PalmNotePadFileOpenDlg (HWND hwnd, LPTSTR pstrFileName, LPTSTR pstrTitleName)
{
	ofn.hwndOwner         = hwnd ;
	ofn.lpstrFile         = pstrFileName ;
	ofn.lpstrFileTitle    = pstrTitleName ;
	ofn.Flags             = OFN_HIDEREADONLY | OFN_CREATEPROMPT ;

	return GetOpenFileName (&ofn) ;
}

BOOL PalmNotePadFileSaveDlg (HWND hwnd, LPTSTR pstrFileName, LPTSTR pstrTitleName)
{
	ofn.hwndOwner         = hwnd ;
	ofn.lpstrFile         = pstrFileName ;
	ofn.lpstrFileTitle    = pstrTitleName ;
	ofn.Flags             = OFN_OVERWRITEPROMPT ;

	return GetSaveFileName (&ofn) ;
}

static long PalmNotePadFileLength (HANDLE hFile)
{
	long iFileLength ;

	iFileLength = GetFileSize (hFile,NULL) ;
	return iFileLength ;
}

BOOL PalmNotePadFileRead (HWND hwndEdit, LPTSTR pstrFileName)
{
	HANDLE hFile;
	long    iLength ;
	LPSTR   pstrBuffer ;
	LPTSTR	ptstrBuffer;
	DWORD   dwNumberOfBytesRead;


	hFile = CreateFile(pstrFileName, 
		GENERIC_READ ,
		FILE_SHARE_READ,
		NULL,
		OPEN_EXISTING, 
		FILE_ATTRIBUTE_NORMAL,
		NULL );

	if (INVALID_HANDLE_VALUE == hFile)
			return FALSE ;

	iLength = GetFileSize (hFile,NULL) ;

	if (NULL == (pstrBuffer = (LPSTR) malloc (iLength)))
	{
		CloseHandle (hFile) ;
		return FALSE ;
	}

	if (NULL == (ptstrBuffer = (LPTSTR) malloc((iLength + 1) * sizeof(TCHAR))))
	{
		CloseHandle (hFile) ;
		return FALSE ;
	}

	ReadFile( hFile, pstrBuffer, iLength, &dwNumberOfBytesRead, NULL);

	MultiByteToWideChar(CP_ACP,									// code page
											MB_PRECOMPOSED,         // character-type options
											pstrBuffer,							// address of string to map
											dwNumberOfBytesRead,		// number of bytes in string
											ptstrBuffer,						// address of wide-character buffer
											(iLength + 1) * sizeof(TCHAR));        // size of buffer);


	SetWindowText (hwndEdit, ptstrBuffer) ;
	free(pstrBuffer);
	free(ptstrBuffer);
	CloseHandle (hFile) ;

	return TRUE ;
}

BOOL PalmNotePadFileWrite (HWND hwndEdit, LPTSTR pstrFileName)
{
	HANDLE hFile;
	long    iLength ;
	LPSTR   pstrBuffer ;
	LPTSTR	ptstrBuffer;
	DWORD   dwNumberOfBytesWritten;

	hFile = CreateFile(pstrFileName, 
		GENERIC_WRITE,
		FILE_SHARE_WRITE,
		NULL,
		CREATE_ALWAYS, 
		FILE_ATTRIBUTE_NORMAL,
		NULL );

	if (INVALID_HANDLE_VALUE == hFile)
			return FALSE ;

	iLength = GetWindowTextLength (hwndEdit) ;
		
	if (NULL == (pstrBuffer = (LPSTR) malloc (iLength + 1)))
	{
		CloseHandle (hFile) ;
		return FALSE ;
	}
	
	if (NULL == (ptstrBuffer = (LPTSTR) malloc ((iLength + 1) * sizeof(TCHAR))))
	{
		CloseHandle (hFile) ;
		return FALSE ;
	}

	GetWindowText (hwndEdit, ptstrBuffer, iLength + 1) ;

	WideCharToMultiByte(CP_ACP, 
											0, 
											(LPTSTR)ptstrBuffer, 
											-1, 
											(LPSTR)pstrBuffer, 
											(lstrlen(ptstrBuffer) + 1) * sizeof(TCHAR), 
											NULL, 
											NULL);

	if (!WriteFile( hFile, pstrBuffer, iLength, &dwNumberOfBytesWritten, NULL)) return FALSE;

	if (iLength != (long)dwNumberOfBytesWritten )
	{
		CloseHandle (hFile) ;
		free (pstrBuffer) ;
		free (ptstrBuffer) ;
		return FALSE ;
	}

	CloseHandle (hFile) ;
	free (pstrBuffer) ;
	free (ptstrBuffer) ;

	return TRUE ;
}


